import { Router } from 'express';
import { debugController } from './controller';
import { authenticateUser, requireAdmin } from '@/middlewares/auth';
import { checkFeature } from '@/middlewares/featureGate';

const router = Router();

// Debug middleware - requires admin role and debug tools feature
const debugMiddleware = [
  authenticateUser,
  requireAdmin, // Superadmins and QA staff
  checkFeature('allow_debug_tools')
];

// Basic ping endpoint (no auth required for basic health check)
router.get('/ping', debugController.ping);

// All other debug endpoints require authentication and debug tools feature
router.get('/supabase', debugMiddleware, debugController.testSupabase);
router.get('/user/:user_id', debugMiddleware, debugController.getUserDebugInfo);
router.post('/feature-check', debugMiddleware, debugController.checkFeature);
router.post('/subscription-check', debugMiddleware, debugController.checkSubscription);
router.post('/ai-log', debugMiddleware, debugController.testAILog);
router.get('/system-status', debugMiddleware, debugController.getSystemStatus);
router.get('/cache', debugMiddleware, debugController.getCacheDebugInfo);

export default router; 